/******************************************************************************/
class SpawnLight : BaseEvent
{
public:
            SpawnLight();
   virtual ~SpawnLight();
   
   virtual void create(Object &obj);
   virtual void AfterCreate(      ); 

   virtual uint drawPrepare();
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();

   VarPointLight* m_VarPointLight;
   UID m_VarPointLightUID;
   
   bool m_DrawLight;
};
/******************************************************************************/
SpawnLight::SpawnLight() : BaseEvent(), m_DrawLight(false), m_VarPointLight(null)       
{
   
}
SpawnLight::~SpawnLight()
{
   
}
/******************************************************************************/
void SpawnLight::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("VarLightUID")) m_VarPointLightUID = p.asID();
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void SpawnLight::AfterCreate()
{
   // Find the correct VarPointLight to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(variablesPointLight)
      if(variablesPointLight[i].id() == m_VarPointLightUID)
         m_VarPointLight = &variablesPointLight[i];
         
   DEBUG_ASSERT(m_VarPointLight != null, "SpawnLight: Light var not found in scene");
}
/******************************************************************************/
uint SpawnLight::drawPrepare()
{
   if(m_VarPointLight) // If the event starts drawing
      if(m_VarPointLight->GetDraw()) // If the light also wants to be drawn
         LightPoint(m_VarPointLight->GetPower(), m_VarPointLight->GetPos(), m_VarPointLight->GetColor(), m_VarPointLight->GetVol(), m_VarPointLight.GetVolMax()).add();
   
   return 0;
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void SpawnLight::CallTriggeredAction()
{
   m_VarPointLight->SetDraw(true); // Start drawing a light in drawPrepare()
}

// This method is called when the duration of the event has been reached
void SpawnLight::StopTriggeredAction()
{
   m_VarPointLight->SetDraw(false); // Stop drawing a light in drawPrepare()
}
/******************************************************************************/
